# -*- coding: utf-8 -*-
# createTime: 2018/8/16 10:41

"""
sale -> purchase (partner_id, brand_id)
"""

from odoo import models, fields, api
from odoo.tools import DEFAULT_SERVER_DATETIME_FORMAT
from odoo.tools.translate import _
from odoo.exceptions import UserError


class ProcurementRule(models.Model):
    _inherit = 'procurement.rule'

    @api.multi
    def _run_buy(self, product_id, product_qty, product_uom, location_id, name, origin, values):

        cache = {}
        suppliers = product_id.seller_ids.filtered(
            lambda r: (not r.company_id or r.company_id == values['company_id']) and (
                    not r.product_id or r.product_id == product_id)
        )
        if not suppliers:
            msg = _('There is no vendor associated to the product %s. '
                    'Please define a vendor for this product.') % (product_id.display_name,)
            raise UserError(msg)

        brand_id = product_id.brand_id.id
        if not brand_id:
            msg1 = _('[{}] don\'t have a brand, '
                     'please create a brand for the product.'.format(product_id.name))
            raise UserError(msg1)

        # supplier = self._make_po_select_supplier(values, suppliers)
        supplier = suppliers[0]
        partner = supplier.name

        domain = self._make_po_get_domain_inherit(values, partner, brand_id)

        if domain in cache:
            po = cache[domain]
        else:
            po = self.env['purchase.order'].sudo().search([dom for dom in domain])
            po = po[0] if po else False
            cache[domain] = po
        if not po:
            vals = self._prepare_purchase_order_inherit(product_id, product_qty, product_uom, origin, values, partner)
            company_id = values.get('company_id') and values['company_id'].id or self.env.user.company_id.id
            po = self.env['purchase.order'].with_context(force_company=company_id).sudo().create(vals)
            cache[domain] = po
        elif not po.origin or origin not in po.origin.split(', '):
            if po.origin:
                if origin:
                    po.write({'origin': po.origin + ', ' + origin, 'brand_id': brand_id})
                else:
                    po.write({'origin': po.origin, 'brand_id': brand_id})
            else:
                po.write({'origin': origin, 'brand_id': brand_id})

        # Create Line
        po_line = False
        for line in po.order_line:
            if line.product_id == product_id and line.product_uom == product_id.uom_po_id:
                if line._merge_in_existing_line(product_id, product_qty, product_uom,
                                                location_id, name, origin, values):
                    vals = self._update_purchase_order_line(product_id, product_qty, product_uom, values, line, partner)
                    po_line = line.write(vals)
                    break
        if not po_line:
            vals = self._prepare_purchase_order_line(product_id, product_qty, product_uom, values, po, supplier)
            self.env['purchase.order.line'].sudo().create(vals)
        # super(ProcurementRule, self)._run_buy(
        #     product_id, product_qty, product_uom,
        #     location_id, name, origin, values
        # )

        # print("run the inherit run buy ")

    def _make_po_get_domain_inherit(self, values, partner, brand_id):
        domain = super(ProcurementRule, self)._make_po_get_domain(values, partner)
        gpo = self.group_propagation_option
        group = (gpo == 'fixed' and self.group_id) or \
                (gpo == 'propagate' and 'group_id' in values and values['group_id']) or False

        domain += (
            ('partner_id', '=', partner.id),
            ('state', '=', 'draft'),
            ('picking_type_id', '=', self.picking_type_id.id),
            ('company_id', '=', values['company_id'].id),
            ('brand_id', '=', brand_id)
        )

        if group:
            domain += (('group_id', '=', group.id),)
        return domain

    def _prepare_purchase_order_inherit(self, product_id, product_qty, product_uom, origin, values, partner):
        schedule_date = self._get_purchase_schedule_date(values)
        purchase_date = self._get_purchase_order_date(product_id, product_qty, product_uom, values, partner,
                                                      schedule_date)
        fpos = self.env['account.fiscal.position'].with_context(
            force_company=values['company_id'].id).get_fiscal_position(partner.id)

        gpo = self.group_propagation_option
        group = (gpo == 'fixed' and self.group_id.id) or \
                (gpo == 'propagate' and values.get('group_id') and values['group_id'].id) or False

        return {
            'partner_id': partner.id,
            'picking_type_id': self.picking_type_id.id,
            'company_id': values['company_id'].id,
            'currency_id': partner.with_context(force_company=values[
                'company_id'].id).property_purchase_currency_id.id or self.env.user.company_id.currency_id.id,
            'dest_address_id': values.get('partner_dest_id', False) and values['partner_dest_id'].id,
            'origin': origin,
            'payment_term_id': partner.with_context(
                force_company=values['company_id'].id).property_supplier_payment_term_id.id,
            'date_order': purchase_date.strftime(DEFAULT_SERVER_DATETIME_FORMAT),
            'fiscal_position_id': fpos,
            'group_id': group,
            'brand_id': product_id.brand_id.id,
        }
