# -*- coding: utf-8 -*-
# author: Liberty
# filename: inherited_product_supplierinfo
# create time: 2018/8/31 14:34

from odoo import models, api, fields


class SupplierInfo(models.Model):
    _inherit = 'product.supplierinfo'

    @api.depends('product_tmpl_id.brand_id')
    def _compute_brand(self):
        for b in self:
            b.brand_id = b.product_tmpl_id.brand_id

    brand_id = fields.Many2one('product.brand', string='Brand', compute=_compute_brand, store=1)
