# -*- coding: utf-8 -*-
# author: Liberty
# filename: inherited_stock_move_line
# create time: 2018/9/10 11:21

from odoo import models, fields, api


class StockMoveLine(models.Model):
    _inherit = 'stock.move.line'

    @api.depends('product_id.product_tmpl_id')
    def _compute_warranty_card(self):
        for obj in self:
            obj.warranty_card = obj.product_id.product_tmpl_id.warranty_card

    @api.depends('product_id.product_tmpl_id')
    def _compute_has_box(self):
        for obj in self:
            obj.has_box = obj.product_id.product_tmpl_id.has_box

    warranty_card = fields.Boolean(string='Warranty')
    has_box = fields.Boolean(string='Has Box')
    acceptance = fields.Boolean(default=1, string='Acceptance')
