# -*- coding: utf-8 -*-
# author: Liberty
# filename: inherited_stock_production_lot
# create time: 2018/9/20 15:55

from odoo import models, fields, api


class StockProductionLot(models.Model):
    _inherit = 'stock.production.lot'

    def _compute_warranty_card(self):
        for obj in self:
            move_line = self.env['stock.move.line'].search([('lot_id', '=', self.id)])
            if move_line:
                move_line = move_line[0]
                obj.warranty_card = move_line.warranty_card

    def _compute_box(self):
        for obj in self:
            move_line = self.env['stock.move.line'].search([('lot_id', '=', self.id)])
            if move_line:
                move_line = move_line[0]
                obj.has_box = move_line.has_box

    warranty_card = fields.Boolean(string='Warranty', compute=_compute_warranty_card)
    has_box = fields.Boolean(string='Has Box', compute=_compute_box)

# class StockPicking(models.Model):
#     _inherit = 'stock.picking'
#
#     @api.multi
#     def button_validate(self):
#         data = super(StockPicking, self).button_validate()
#         print('return data: ', data)
#         return data
