# -*- coding: utf-8 -*-

from odoo import models, fields, api
from odoo.exceptions import ValidationError
from odoo.tools.translate import _


class ProductBrand(models.Model):
    _name = 'product.brand'
    _description = 'Product Brand'
    name = fields.Char('Brand(Chinese)', required=True)
    active = fields.Boolean('Is Active', default=True)
    description = fields.Text('Description')
    english_name = fields.Char('Brand(English)', required=True)

    # partner_id = fields.Many2one('res.partner', string='Supplier')

    @api.multi
    def name_get(self):
        # for obj in self:
        #     if brand.english_name is not None:
        #         res.append(brand.english_name)
        #     if brand.name is not None:
        #         res.append('/')
        #         res.append(brand.name)
        #     print('brand name:', res)
        return [(obj.id, '{} / {}'.format(obj.english_name, obj.name)) for obj in self]

    _sql_constraints = [
        ('module_name_uniq', 'UNIQUE (name)', 'Product brand name must be unique.')
    ]

    # @api.constrains('name')
    # def _check_name_length(self):
    #     for n in self:
    #         if not len(n.name) > 2:
    #             msg = "The length of the product brand name must be greater than 2."
    #             raise ValidationError(_(msg))


class ProductTemplate(models.Model):
    _inherit = 'product.template'
    brand_id = fields.Many2one('product.brand', 'Product Brand', ondelete='set null')
    standard_price_currency = fields.Many2one('res.currency', string='StandardPriceCurrency')


class PurchaseOrder(models.Model):
    _inherit = 'purchase.order'
    brand_id = fields.Many2one(
        'product.brand', 'Product Brand', ondelete='set null',
        # domain="[('partner_id', '=', partner_id)]"
    )
