# -*- coding: utf-8 -*-
# filename: price_relations
# create time: 2018/8/20 10:34


from odoo import api, fields, models, tools


class PriceReport(models.Model):
    _name = 'price.relations.report'
    _description = 'Compare Prices'
    _auto = False

    name = fields.Char('Order Number')
    date_order = fields.Datetime('Date')
    partner_id = fields.Many2one('res.partner', string='Supplier/Customer')
    brand_id = fields.Many2one('product.brand', string='Brand')
    uom_id = fields.Many2one('product.uom', string='Unit of measurement')
    product_qty = fields.Float('Number')
    price_unit = fields.Float('Unit Prices')
    price_total = fields.Float('Subtotal')
    product_id = fields.Many2one('product.product', string='Product')
    order_type = fields.Char('Order Type')

    @api.model_cr
    def init(self):
        tools.drop_view_if_exists(self._cr, self._table)
        self._cr.execute("""CREATE OR REPLACE VIEW %s as (%s)""" % (self._table, self.get_sql()))

    @staticmethod
    def get_sql():
        _sql = """
        SELECT
            (2147483647 - pol.ID) AS ID,
            po.NAME,
            po.date_order,
            po.partner_id,
            po.brand_id,
            pol.product_uom AS uom_id,
            pol.product_qty,
            pol.price_unit,
            pol.price_total,
            pol.product_id,
            'P' AS order_type 
        FROM
            purchase_order_line pol
            LEFT JOIN purchase_order po ON pol.order_id = po.ID
        WHERE po.state = 'purchase'
    UNION ALL
        SELECT
            sol.ID,
            so.NAME,
            so.date_order,
            so.partner_id,
            NULL AS brand_id,
            sol.product_uom AS uom_id,
            sol.product_uom_qty AS product_qty,
            sol.price_unit,
            sol.price_total,
            sol.product_id,
            'S' AS order_type 
        FROM
            sale_order_line sol
            LEFT JOIN sale_order so ON sol.order_id = so.ID
        WHERE so.state = 'sale'
        """
        return _sql
