# -*- coding: utf-8 -*-
# author: Liberty
# filename: unpass_report
# create time: 2018/9/11 15:34

from datetime import datetime

# noinspection PyUnresolvedReferences
from odoo import models, fields, api, tools


class UnpassStockMove(models.Model):
    _name = 'bode.stock.move'
    _description = 'Non-acceptable Report'

    def _compute_active(self):
        pass

    name = fields.Char('Reference')
    sequence = fields.Integer('Sequence', default=10)
    origin = fields.Char("Source Document")
    create_date = fields.Datetime('Creation Date')
    origin_date = fields.Datetime('Origin Date')
    partner_id = fields.Many2one('res.partner', string='Partner')
    location_dest_id = fields.Many2one('stock.location', string='Stock Location')
    move_line_ids = fields.One2many('bode.stock.move.line', 'move_id', domain=[('is_active', '=', 1)])
    picking_id = fields.Many2one('stock.picking')
    is_active = fields.Boolean(default=True)
    backorder_id = fields.Many2one('stock.picking', string='Back Order of')


class UnpassStockMoveLine(models.Model):
    _name = 'bode.stock.move.line'
    _description = 'Non-acceptable Report Line'

    move_id = fields.Many2one('bode.stock.move', 'Stock Move', ondelete="cascade")
    product_id = fields.Many2one('product.product', 'Product', required=True)
    unpass_reason = fields.Char('Non-acceptable Reason')
    unpass_photo = fields.Binary('Non-acceptable Photo')
    lot_id = fields.Many2one('stock.production.lot', 'Lot')
    lot_name = fields.Char('Lot/Serial Number')
    product_qty = fields.Float('Quantity')
    qty_done = fields.Float('Quantity Done')
    product_uom_id = fields.Many2one('product.uom', 'Unit of Measure')
    picking_id = fields.Many2one('stock.picking')
    stock_move_line_id = fields.Integer()  # stock move line id
    is_active = fields.Boolean(default=True)


# noinspection PyPep8Naming
class StockPicking(models.Model):
    _inherit = 'stock.picking'

    @api.multi
    def button_validate(self):

        StockMoveLine = self.env['stock.move.line']
        BodeMoveLine = self.env['bode.stock.move.line']
        BodeMove = self.env['bode.stock.move']

        bode_move = BodeMove.search([('picking_id', '=', self.id)])
        move_lines = StockMoveLine.search([('picking_id', '=', self.id), ('acceptance', '=', 0)])

        if move_lines and not bode_move:
            print("create bode_move...")
            attrs = {
                'name': self.name,
                'origin': self.origin,
                'create_date': datetime.now().strftime('%Y-%m-%d %H:%M:%S'),
                'partner_id': self.partner_id.id if self.partner_id.id else None,
                'location_dest_id': self.location_dest_id.id if self.location_dest_id.id else None,
                'picking_id': self.id,
                'backorder_id': self.backorder_id.id,
            }
            bode_move = BodeMove.create(attrs)

        # exist_move_lines = BodeMoveLine.search([
        #     ('picking_id', '=', self.id),
        #     ('stock_move_line_id', 'in', move_lines.ids),
        # ])

        # final_move_lines = move_lines
        # if exist_move_lines:
        #     print("in exist bode move line")
        #     exist_bode_move_lines_ids = []
        #     for obj in exist_move_lines:
        #         exist_bode_move_lines_ids.append(obj.stock_move_line_id)
        #     final_move_lines = move_lines.filtered(lambda x: x.id not in exist_bode_move_lines_ids)

        for line in move_lines:
            line_dict = {
                'product_id': line.product_id.id,
                'lot_id': line.lot_id.id if line.lot_id else None,
                'lot_name': line.lot_name,
                'qty_done': line.qty_done,
                'product_uom_id': line.product_uom_id.id if line.product_uom_id else None,
                'picking_id': self.id,
                'stock_move_line_id': line.id,
                'move_id': bode_move.id,
                'product_qty': line.product_qty,
            }
            BodeMoveLine.create(line_dict)

        # for line in move_lines:
        #     print('in update mode move line')
        #
        #     bml_obj = BodeMoveLine.search([
        #         ('stock_move_line_id', '=', line.id),
        #         ('product_id', '=', line.product_id.id),
        #         ('picking_id', '=', self.id)
        #     ])
        #     print('qty_done: ', line.qty_done)
        #
        #     bml_obj.update({'qty_done': line.qty_done, 'is_active': not line.acceptance})
        #
        # acceptance_move_line = StockMoveLine.search(
        #     [('picking_id', '=', self.id), ('acceptance', '=', True)]
        # )
        # acceptance_bode_line = BodeMoveLine.search([
        #     ('picking_id', '=', self.id),
        #     ('stock_move_line_id', 'in', acceptance_move_line.ids)
        # ])
        # if acceptance_bode_line:
        #     print('change accept')
        #     for obj in acceptance_bode_line:
        #         obj.update({'is_active': False})

        _data = super(StockPicking, self).button_validate()

        # move_lines = self.env['stock.move.line'].search([('picking_id', '=', self.id)])
        # print('lot_id: ', move_lines.read(['lot_id', 'lot_name']))

        return _data
