# -*- coding: utf-8 -*-
# author: Liberty
# filename: stock_move_line
# create time: 2018/10/25 15:01

import datetime

from odoo import fields, models, api


class StockMoveLine(models.Model):
    _inherit = 'stock.move.line'

    qty_available = fields.Float(
        'Quantity On Hand', help='The quantity in hand field of associated product information',
        related='product_id.qty_available'
    )

    image_small = fields.Binary(
        'Product Photo', help='Image field in associated product information',
        related='product_id.image_small'
    )

    survival_days = fields.Integer(
        'Survival days', help='The date of the earliest batch so far',
        compute='_get_survival_day'
    )

    @api.one
    @api.depends('lot_id.create_date')
    def _get_survival_day(self):
        lots = self.env['stock.production.lot'].search([('product_id', '=', self.product_id.id)])
        if lots:
            # get str date
            _date = lots.sorted(key='create_date', reverse=False)[0].create_date
            current = datetime.datetime.now()
            self.survival_days = _get_days(_date, current)

        else:
            self.survival_days = 0


def _get_days(before: str, current_date):
    before_date = datetime.datetime.strptime(before, '%Y-%m-%d %H:%M:%S')
    _days = current_date - before_date
    return _days.days
