# -*- coding: utf-8 -*-

from odoo import models, fields, api, _


class InheritMrpBom(models.Model):
    _inherit = 'mrp.bom'

    @api.constrains('product_tmpl_id', 'product_id', 'is_return_goods')
    def check_product(self):
        if self.is_return_goods:
            if self.product_id:
                product = self.search([('product_id', '=', self.product_id.id), ('is_return_goods', '=', True)])
                if product - self:
                    raise Warning(_(u'同一产品变体只能有一个退货物料清单'))
            else:
                product_template = self.env['mrp.bom'].search(
                    [('product_tmpl_id', '=', self.product_tmpl_id.id), ('product_id', '=', False),
                     ('is_return_goods', '=', True)])
                if product_template - self:
                    raise Warning(_(u'同一产品只能有一个退货物料清单'))

    is_return_goods = fields.Boolean(string=u'退货物料清单', copy=False)


class InheritCrmClaimEpt(models.Model):
    _inherit = 'crm.claim.ept'

    @api.onchange('picking_id')
    def onchange_picking_id(self):
        if self.picking_id:
            self.partner_id = self.picking_id.partner_id.id
            self.partner_phone = self.picking_id.partner_id.phone
            self.email_from = self.picking_id.partner_id.email
            self.sale_id = self.picking_id.sale_id.id
            claim_line_ids = []
            for move in self.picking_id.move_lines:
                bom = self.env['mrp.bom'].search(
                    [('is_return_goods', '=', True), ('product_id', '=', move.product_id.id)])
                if not bom:
                    bom = self.env['mrp.bom'].search(
                        [('product_tmpl_id', '=', move.product_id.product_tmpl_id.id), ('product_id', '=', False),
                         ('is_return_goods', '=', True)])
                if bom:
                    product_qty = bom.product_qty
                    if product_qty <= 0:
                        qty_done = move.quantity_done
                        claim_line_ids += [
                            (0, 0, {'product_id': move.product_id.id, 'quantity': qty_done, 'move_id': move.id})]
                    else:
                        product_ids = bom.bom_line_ids.mapped("product_id")
                        for product in product_ids:
                            mrp = bom.bom_line_ids.filtered(lambda p: p.product_id.id == product.id)
                            qty = sum(mrp.mapped('product_qty'))
                            par_product_qty = qty / product_qty
                            qty_done = move.quantity_done * par_product_qty
                            claim_line_ids += [
                                (0, 0, {'product_id': product.id, 'quantity': qty_done, 'move_id': move.id})]
                else:
                    claim_line_ids += [(0, 0, {'product_id': move.product_id.id, 'quantity': move.product_uom_qty,
                                               'move_id': move.id})]
            self.claim_line_ids = claim_line_ids


class InheritClaimLineEpt(models.Model):
    _inherit = 'claim.line.ept'

    @api.multi
    def get_done_quantity(self):
        for record in self:
            for move in record.move_id:
                bom = self.env['mrp.bom'].search(
                    [('is_return_goods', '=', True), ('product_id', '=', move.product_id.id)])
                if not bom:
                    record.done_qty = record.move_id.quantity_done
                else:
                    product_qty = bom.product_qty
                    if product_qty <= 0:
                        record.done_qty = record.move_id.quantity_done
                    else:
                        mrp = bom.bom_line_ids.filtered(lambda p: p.product_id.id == record.product_id.id)
                        if len(mrp) > 1:
                            qty = sum(mrp.mapped('product_qty'))
                        else:
                            qty = mrp.product_qty
                        par_product_qty = qty / product_qty
                        qty_done = move.quantity_done * par_product_qty
                        record.done_qty = qty_done

    @api.constrains('quantity')
    def check_qty(self):
        if self.quantity < 0:
            raise Warning(_(u'数量必须是正数'))
        elif self.quantity > self.done_qty:
            raise Warning(_(u'数量必须小于或等于交付的数量'))