# -*- coding: utf-8 -*-

from odoo import api, fields, models, _


class SaleOrder(models.Model):
    _inherit = "sale.order"
    
    # 打包完成数量及百分比
    qty_picked = fields.Float('Picked quantity', compute='_compute_completed_qty', digits=(6, 0))
    percent_picked = fields.Float('Picked percent(%)', compute='_compute_completed_qty')
    # 已发货数量及百分比
    qty_delivered = fields.Float('Deliverd quantity', compute='_compute_completed_qty', digits=(6, 0))
    percent_delivered = fields.Float('Deliverd percent(%)', compute='_compute_completed_qty')
    # 已开票数量及百分比    
    qty_invoiced = fields.Float('Invoiced quantity', compute='_compute_completed_qty', digits=(6, 0))
    percent_invoiced = fields.Float('Invoiced percent(%)', compute='_compute_completed_qty')
    
    # 计算打包完成数量及百分比
    @api.multi
    @api.depends('order_line')
    def _compute_completed_qty(self):
        for order in self:
            qty_total = sum([l.product_uom_qty for l in order.order_line])
            qty_picked = sum([l.qty_picked for l in order.order_line])
            qty_delivered = sum([l.qty_delivered for l in order.order_line])
            qty_invoiced = sum([l.qty_invoiced for l in order.order_line])
            order.qty_picked = qty_picked
            order.qty_delivered = qty_delivered
            order.qty_invoiced = qty_invoiced
            order.percent_picked = round(qty_picked / qty_total * 100) if qty_total > 0 else 0
            order.percent_delivered = round(qty_delivered / qty_total * 100) if qty_total > 0 else 0
            order.percent_invoiced = round(qty_invoiced / qty_total * 100) if qty_total > 0 else 0