# -*- coding: utf-8 -*-

from odoo import api, fields, models, _


class SaleOrderLine(models.Model):
    _inherit = "sale.order.line"

    # 打包完成数量及百分比
    qty_picked = fields.Float('Picked quantity', compute='_compute_completed_qty', digits=(6, 0))
    percent_picked = fields.Float('Picked percent(%)', compute='_compute_completed_qty')
    # 已发货数量，已开票数量
    percent_delivered = fields.Float('Deliverd percent(%)', compute='_compute_completed_qty')
    percent_invoiced = fields.Float('Invoiced percent(%)', compute='_compute_completed_qty')

    # 计算打包完成数量及百分比
    @api.multi
    @api.depends('product_uom_qty', 'move_ids', 'qty_delivered', 'qty_invoiced')
    def _compute_completed_qty(self):
        for line in self:
            filtered_move_ids = line.move_ids.filtered(lambda mv: mv.picking_type_id.code == 'internal' and mv.state in ('done', 'cancel'))
            qty_done = sum([l.quantity_done for l in filtered_move_ids])
            line.qty_picked = qty_done
            line.percent_picked = round(qty_done / line.product_uom_qty * 100) if line.product_uom_qty > 0 else 0
            line.percent_delivered = round(line.qty_delivered / line.product_uom_qty * 100) if line.product_uom_qty > 0 else 0
            line.percent_invoiced = round(line.qty_invoiced / line.product_uom_qty * 100) if line.product_uom_qty > 0 else 0

    # 查看产品的历史报价与销售价格
    def action_view_product_price_history(self):
        fr_type = self.order_id.fr_type or self.order_id.partner_id.fr_type
        if fr_type:
            self = self.with_context({'fr_type': fr_type})            
        return self.product_id.product_tmpl_id.action_view_product_price_history()
