# -*- coding: utf-8 -*-

from odoo import api, fields, models, _


class SaleReport(models.Model):
    _inherit = "sale.report"

    currency_id = fields.Many2one('res.currency', string='Currency', compute='_compute_price_unit')
    price_unit = fields.Float('Price unit', compute='_compute_price_unit')
    fr_type = fields.Selection([('in', 'In'), ('out', 'Out')], related='partner_id.fr_type', readonly=True)

    @api.multi
    def _compute_price_unit(self):
        for item in self:
            item.currency_id = item.pricelist_id.currency_id.id
            item.price_unit = 0 if item.product_uom_qty == 0 else item.price_subtotal / item.product_uom_qty * item.currency_id.rate
