from odoo import api,fields,models


class PartnerGoods(models.Model):
    _name = 'partner.goods'
    _description = 'Partner Goods'

    partner_id = fields.Many2one('partner', index=True, copy=False, required=True, ondelete='restrict')
    goods_id = fields.Many2one('goods',
                               '商品',
                               required=True,
                               ondelete='restrict',
                               help='商品')
    partner_goods_name = fields.Char('对方名称', required=True)

    def name_get(self):
        '''在many2one字段里显示 名称'''
        res = []

        for partner_goods in self:
            res.append((partner_goods.id, partner_goods.partner_goods_name))
        return res

    @api.model
    def name_search(self, name='', args=None, operator='ilike', limit=100):
        '''在many2one字段中支持按编号搜索'''
        args = args or []
        name_search_goods = []
        if name:
            goods_id = self.search([('partner_goods_name', '=', name)])
            if goods_id:
                return goods_id.name_get()
            args.append(('partner_goods_name', 'ilike', name))
            goods_ids = self.search(args)
            if goods_ids:
                name_search_goods = goods_ids.name_get()
        search_goods = super().name_search(name=name, args=args,
                                                      operator=operator, limit=limit)
        for good_tup in name_search_goods:  # 去除重复产品
            if good_tup not in search_goods:
                search_goods.append(good_tup)
        return search_goods


class Goods(models.Model):
    _inherit = 'goods'

    def name_get(self):
        '''在many2one字段里显示 编号_名称'''
        res = []
        partner_id = None
        if 'partner_id' in super()._context:
            partner_id = super()._context['partner_id']
        for Goods in self:
            if partner_id:
                partner_goods = self.env['partner.goods']
                partner_goods_id = partner_goods.search([('partner_id','=',partner_id),('goods_id', '=', Goods.id)])
                if partner_goods_id:
                    res.append((Goods.id, Goods.code and (
                        Goods.code + '_' + Goods.name+'[%s]' % partner_goods_id.partner_goods_name) or Goods.name))
                else:
                    res.append((Goods.id, Goods.code and (
                            Goods.code + '_' + Goods.name) or Goods.name))
            else:
                res.append((Goods.id, Goods.code and (
                        Goods.code + '_' + Goods.name) or Goods.name))
        return res

    @api.model
    def name_search(self, name='', args=None, operator='ilike', limit=100):
        '''在many2one字段中支持按编号搜索'''
        args = args or []
        code_search_goods = []

        if 'partner_id' in super(Goods, self)._context:
            partner_id = super(Goods, self)._context['partner_id']
            partner_goods = self.env['partner.goods']
            partner_goods_ids = partner_goods.search([('partner_id', '=', partner_id),
                                                      ('partner_goods_name', 'ilike', name)])
            for partner_goods_id in partner_goods_ids:
                code_search_goods.append(partner_goods_id.goods_id.name_get()[0])

        if name:
            goods_id = self.search([('code', '=', name)])
            if goods_id:
                return goods_id.name_get()
            args.append(('code', 'ilike', name))
            goods_ids = self.search(args)
            if goods_ids:
                code_search_goods = goods_ids.name_get()

            args.remove(('code', 'ilike', name))
        search_goods = super(Goods, self).name_search(name=name, args=args,
                                                      operator=operator, limit=limit)
        for good_tup in code_search_goods:  # 去除重复产品
            if good_tup not in search_goods:
                search_goods.append(good_tup)
        return search_goods


class Partner(models.Model):
    _inherit = 'partner'

    partner_goods_id = fields.One2many('partner.goods', 'partner_id', '客商货品', copy=True, auto_join=True)