# -*- coding: utf-8 -*-

from odoo import api, fields, models, _
import logging

_logger = logging.getLogger(__name__)


class ProductPriceHistoryWizard(models.TransientModel):
    _name = "product.price.history.wizard"

    product_id = fields.Many2one('product.template', string='Product')
    sale_price_ids = fields.Many2many('sale.report', string='Sale history')
    quotation_price_ids = fields.Many2many('sale.report', string='Quotation history')

    @api.model
    def default_get(self, fields_list):
        res = super(ProductPriceHistoryWizard, self).default_get(self)
        context = self.env.context
        _logger.info(context)
        if context.get('default_product_id', False):
            product_id = context['default_product_id']
            sale_domain = [('product_id.product_tmpl_id', '=', product_id),('state', 'in', ['sale', 'done']),('product_uom_qty','>',0)]
            quotation_domain = [('product_id.product_tmpl_id', '=', product_id),('state', 'not in', ['cancel','sale','done']),('product_uom_qty','>',0)]
            if context.get('fr_type', False):
                fr_type = context['fr_type']
                sale_domain.append(('fr_type','=',fr_type))
                quotation_domain.append(('fr_type','=',fr_type))
            sale_price_ids = self.env['sale.report'].search(sale_domain)
            quotation_price_ids = self.env['sale.report'].search(quotation_domain)
            res['product_id'] = product_id
            res['sale_price_ids'] = [(6, 0, sale_price_ids.ids)]
            res['quotation_price_ids'] = [(6, 0, quotation_price_ids.ids)]
        return res