odoo.define('search_panel_extension.SPanel',function (require) {
"use strict";

/**
 * 1.扩展search panel,使其在能够工作下搜索对话框中．
 */
	var ListView = require("web.ListView");
	var ListController = require("web.ListController");
	var SearchPanel = require('web.SearchPanel');
	var Dialog = require("web.Dialog");
	var ViewDialog = require("web.view_dialogs");
	var core = require("web.core");
	var pyeval=require("web.py_utils");
	var viewUtils = require('web.viewUtils');
	var QWeb = core.qweb;
	var _t = core._t;
	Dialog.include({
		i_am_a_dialog:""
	});
	
	ListView.include({
		
		getController:function(parent){
			// view is in a dialog?
			if(parent && _.contains(_.allKeys(parent),'i_am_a_dialog') ){
				if (!this.withSearchPanel){
					this.withSearchPanel=true;
				}
			}
			return this._super.apply(this,arguments);
		}	
	});
	
	ListController.include({
		 _onSearchPanelDomainUpdated: function (ev) {
			 // 阻止事件冒泡.防止对话框所有者页上的controller重复相应该事件．
			ev.stopPropagation();
			return this._super.apply(this,arguments);
		 },
	});
	
	SearchPanel.include({
	    /**
	     * 增加toggle按钮，处理SearchPanel的显示和隐藏
	     */
	    on_attach_callback: function () {
	       var self = this;
	       this._super.apply(this,arguments);
	       var $hideButton = QWeb.render("SearchPanel.HideButton",this);
	       var $buttonEl = $(document.createDocumentFragment());
	       $buttonEl.append($hideButton);	       	       
	       $buttonEl.find('button.btn-search-panel-hide').click(function(){
				 if(self.$el.hasClass('o_hidden')){
					 self.do_show();
					 $(this).removeClass('show-panel');
				 }else{
					 self.do_hide();
					 $(this).addClass('show-panel');
				 }
			 }); 
	       this.$el.before($buttonEl);
	    },
	});
});
