# -*- coding: utf-8 -*-

from odoo import models, api, _
from odoo.exceptions import ValidationError
from odoo.tools import config, float_compare


class StockQuant(models.Model):
    _inherit = 'stock.quant'

    @api.multi
    @api.constrains('product_id', 'quantity')
    def check_negative_qty(self):
        p = self.env['decimal.precision'].precision_get(
            'Product Unit of Measure')
        check_negative_qty = (
            (config['test_enable'] and
             self.env.context.get('test_stock_no_negative')) or
            not config['test_enable']
        )
        if not check_negative_qty:
            return
        for quant in self:
            if (
                float_compare(quant.quantity, 0, precision_digits=p) == -1 and
                quant.product_id.type == 'product' and
                not quant.product_id.allow_negative_stock and
                not quant.product_id.categ_id.allow_negative_stock and
                quant.location_id.usage in ['internal', 'transit']
            ):
                msg_add = ''
                if quant.lot_id:
                    msg_add = _(" 批次 '%s'") % quant.lot_id.name_get()[0][1]
                raise ValidationError(_(
                    "库存移动失败：产品 '%s'%s 在位置 (%s) 的库存数量将为负数(%s)。并且该产品不允许负库存。") % (
                    quant.product_id.name, msg_add, quant.location_id.complete_name, quant.quantity))
