odoo.define('web_form_view_cp_buttons', function (require) {
    "use strict";
    
    var core = require('web.core');
    var FormController = require('web.FormController');
    var FormView = require('web.FormView');
    var viewRegistry = require('web.view_registry');
    
    console.log("web_form_view_cp_buttons var def") 

    var CpButtonFormController = FormController.extend({
        renderButtons: function ($node) {
            this._super.apply(this, arguments);
            var ctx = this.initialState.context;
            if ('form' in ctx && 'buttons' in ctx.form) {
                var self = this;
                var form_buttons = ctx.form.buttons;
                _.each(form_buttons, function (button, index) {
                    var button_areas = new Array ('.o_form_buttons_view', '.o_form_buttons_edit');
                    for (var area_index in button_areas) {
                        var btn_index = index+"_"+area_index;
                        var $btn = $('<button>', {
                            text: button.name,
                            "class": 'btn btn-secondary o_form_button_extra_' + btn_index + ' ' + button.classes,
                            type: 'button',
                            title: button.name
                        });
                        var attrs = _.extend({ modifiers: {}, options: {} }, $btn.getAttributes(), { type: 'object', name: button.action });
                        self.$buttons.find(button_areas[area_index]).append($btn);
                        self.$buttons.on('click', '.o_form_button_extra_' + btn_index, self._onActionButtonClick.bind(self, attrs));
                    }
                });
            }
        },
        
        _onActionButtonClick: function (attrs, event) {
            event.stopPropagation();
            this.trigger_up('button_clicked', {
                attrs: attrs,
                record: this.model.get(this.handle)
            });
        }
    });
        

    var CpButtonFormView = FormView.extend({
        config: _.extend({}, FormView.prototype.config, {
            Controller: CpButtonFormController,
        }),
    });
    
    viewRegistry.add('cp_button_form', CpButtonFormView);
    console.log("web_form_view_cp_buttons viewRegistry add") 
    
    return {
        CpButtonFormView: CpButtonFormView,
    };

    
});