#-*- coding:utf-8 -*-

# Author: liuaiqun@sina.com
# Usage: http://blog.sina.com.cn/s/blog_53d318170102wvqc.html


from odoo import models, fields, api
from odoo.tools import DEFAULT_SERVER_DATETIME_FORMAT as DATETIME_FORMAT
import datetime
#import urllib
#import urllib2
import requests
import werkzeug.urls
import json

TIMEOUT = 60

import logging
_logger = logging.getLogger(__name__)


class WechatWorker(models.Model):
    _name = "wechat.worker"
    _description = "wechat worker config"
        
                
    #基本信息            
    name = fields.Char(u'项目', required=True)
    active = fields.Boolean(u'有效', default=True,)
    notes = fields.Text(u'备注')
    corpid = fields.Char('corpid', required=True)
    corpsecret = fields.Char('corpsecret', required=True)
    agentid  = fields.Integer('agentid', required=True)
    token= fields.Char('access token', readonly=True, )
    token_start_time =fields.Datetime(u'toke启用时间',)
    token_delta_time =fields.Integer(u'token有效秒数',)
    token_fail_time =fields.Datetime(u'toke失效时间')
    token_notes=fields.Text(u'token获取结果',)
    
    test_user= fields.Char(u'测试微信号',  )
    test_text= fields.Char(u'测试内容',  )
    test_result=fields.Text(u'测试结果',)
    
    def get_token(self):
        #url="https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=%s&corpsecret=%s"  % (self.corpid, self.corpsecret) 
        url="https://qyapi.weixin.qq.com/cgi-bin/gettoken"
        params={"corpid" : self.corpid,
                "corpsecret" : self.corpsecret, }
        try:
            #f = urllib2.urlopen(url)
            #response = f.read()
            response = requests.get(url, params=params)
            response.raise_for_status()
            self.token_notes =response.text
            self.token_start_time=fields.Datetime.now()
            
            #result= json.loads(response)
            result= response.json()
            err_code = result['errcode']
            err_msg = result['errmsg']
            if err_code==0 and err_msg =='ok' :
                self.token=result['access_token']
                self.token_delta_time=result['expires_in']
                self.token_fail_time= datetime.datetime.now() + datetime.timedelta( seconds=self.token_delta_time)
            else :
                self.token='N/A'
                self.token_delta_time=0
                self.token_fail_time= datetime.datetime.now() 
        except Exception:
             _logger.debug("==== get_token error ======")
             self.token='N/A'
             self.token_delta_time=0
             self.token_fail_time= datetime.datetime.now() 
             self.token_notes ="get_token error"
        
    #@api.multi
    def test_send(self):
        result=self.send_message(self.test_user , self.test_text)  
        self.test_result = result        
        
    #@api.multi
    def send_message(self,users, message):
        current_time= datetime.datetime.now() + datetime.timedelta(seconds=120)
        fail_time   = fields.Datetime.from_string(self.token_fail_time)
       
        #_logger.debug("=== check send weixin   %s %s ", current_time, fail_time)
        if current_time >fail_time :
            self.get_token()
            _logger.debug("token updated")
           
        url="https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=%s" % (self.token) 
        values={"touser":users, 
                 "msgtype":"text",
                 "agentid":self.agentid,
                 "text": {"content": message  } , 
                 "safe":0} 
        _logger.debug("==== values   === %s",values)
        data=json.dumps(values)
        try:
            #req = urllib2.Request(url,data)   
            #resp = urllib2.urlopen(req, timeout = TIMEOUT)   
            #result = resp.read() 
            response = requests.post(url,data,timeout = TIMEOUT)
            response.raise_for_status()
            result =response.text
        except Exception:
            result = "send message error"    
            
        _logger.debug("==== send result=== %s===", result)
        return result
        
